/**
* \file: LibraryEntryPoint.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Android Auto
*
* \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
*          J. Michalik / ADITG/SW1 / jmichalik@de.adit-jv.com
*
* \copyright (c) 2016-2017 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#include <adit_logging.h>
#include <aauto/AditEndpointCommon.h>
#include "AilAudioSink.h"
#include "AilAudioSource.h"

LOG_DECLARE_CONTEXT(aauto_audio);

using namespace adit::aauto;

#ifndef COMP_GIT_VERSION
#define COMP_GIT_VERSION "aauto_r3_d01 or newer"
#endif

namespace adit { namespace aauto {

AditAudioSink* AilAudioSinkCreate(uint8_t inId, MessageRouter* inRouter)
{
    if(inRouter == nullptr)
    {
        LOG_ERROR((aauto_audio, "MessageRouter pointer is null"));
        return nullptr;
    }
    
    return new AilAudioSink(inId, inRouter);
}

AditAudioSource* AilAudioSourceCreate(uint8_t inId, MessageRouter* inRouter,
        int inMediaCodecType)
{
    if(inRouter == nullptr)
    {
        LOG_ERROR((aauto_audio, "MessageRouter pointer is null"));
        return nullptr;
    }
    
    return new AilAudioSource(inId, inRouter, inMediaCodecType);
}

/*
 * In case the library is linked at compile time it is more convenient to call unique functions
 * rather than the generic plug-in versions.
 */

void AilEntryPoint(FactoryRegisterFn inFactoryRegisterFn)
{
    LOG_REGISTER_CONTEXT(aauto_audio, "AUD", "AAUTO audio-endpoint");
    LOGD_DEBUG((aauto_audio, "aauto-ail git tag: %s", COMP_GIT_VERSION));

    if (inFactoryRegisterFn != nullptr)
    {
        // it is not required to use the factory
        inFactoryRegisterFn("AilAudioSink", FactoryAudioSink,
                (CreatorFn)AilAudioSinkCreate);
        inFactoryRegisterFn("AilAudioSource", FactoryAudioSource,
                (CreatorFn)AilAudioSourceCreate);
    }
}

void AilExitPoint()
{
    LOG_UNREGISTER_CONTEXT(aauto_audio);
}

} } // namespace adit { namespace aauto {

extern "C" void aauto_LibraryEntryPoint(FactoryRegisterFn inFactoryRegisterFn)
{
    AilEntryPoint(inFactoryRegisterFn);
}

extern "C" void aauto_LibraryExitPoint()
{
    AilExitPoint();
}
